% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipliers.R
\name{multipliers}
\alias{multipliers}
\title{Multipliers}
\usage{
multipliers(deasol)
}
\arguments{
\item{deasol}{Object of class dea or dea_fuzzy obtained with some of the DEA model functions.}
}
\description{
Extract the multipliers of the DMUs from a dea or dea_fuzzy solution.
}
\examples{
data("Coll_Blasco_2006")
data_example <- read_data(Coll_Blasco_2006,
                          ni = 2, 
                          no = 2)
result <- model_multiplier(data_example,
                           orientation = "io", 
                           rts = "crs")
multipliers(result)
 
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
