% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Kao_Liu_2003}
\alias{Kao_Liu_2003}
\title{Data: Kao and Liu (2003).}
\format{Data frame with 24 rows and 11 columns. Definition of fuzzy inputs (X) and fuzzy outputs (Y):
\describe{
  \item{x1 = Patronage}{It is a weighted sum of the standardized scores of faculty, graduate students, undergraduate students, and extension students in the range of 0 and 1.}
  \item{y1 = Collections}{Books, serials, microforms, audiovisual works, and database.}
  \item{y2 = Personnel}{Classified staff, unclassified staff, and student assistants.}
  \item{y3 = Expenditures }{Capital expenditure, operating expenditure, and special expenditure.}
  \item{y4 = Buildings}{Area and seats}
  \item{y5 = Services}{Operating hours, attendance, circulation, communication channels, range of services, amount of services, etc.}
  \item{beta3_l}{lower spread vector Expenditures}
  \item{beta3_u}{upper spread vector Expenditures}
  \item{beta5_l}{lower spread vector Services}
  \item{beta5_u}{upper spread vector Services}
}}
\source{
Kao, C., Liu, S.T. (2003). “A mathematical programming approach to fuzzy efficiency ranking”, International Journal of Production Economics, 85, \code{doi}: 10.1016/S0925-5273(03)00026-4
}
\usage{
data("Kao_Liu_2003")
}
\description{
Data of 24 university libraries in Taiwan with one input and five outputs.
}
\note{
There are three observations that are missing: expenditures of Library 24 and services of Library 22 and Library 23. Kao and Liu (2000b) represent the expenditures of Library 24 by the triangular fuzzy number Y=(0.11; 0.41; 1.0). The services of Library 22 and Library 23 are expressed by a same triangular fuzzy number Y=(0.41; 0.69; 1.0).
}
\examples{
# Example. Replication of results in Kao and Liu (2003, p.152)
data_example <- read_data_fuzzy(Kao_Liu_2003,
                                dmus=1,
                                inputs.mL= 2,
                                outputs.mL= 3:7,
                                outputs.dL=c(NA,NA,8,NA,10),
                                outputs.dR=c(NA,NA,9,NA,11))
result <- modelfuzzy_kaoliu(data_example,
                            kaoliu_modelname = "basic",
                            orientation="oo",
                            rts="vrs",
                            alpha=0)
eff <- efficiencies(result)
eff

}
\seealso{
\code{\link{read_data_fuzzy}}, \code{\link{model_basic}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
