% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_fuzzy.R
\name{read_data_fuzzy}
\alias{read_data_fuzzy}
\title{read_data_fuzzy}
\usage{
read_data_fuzzy(datadea,
             dmus,
             inputs.mL,
             inputs.mR = NULL,
             inputs.dL = NULL,
             inputs.dR = NULL,
             outputs.mL,
             outputs.mR = NULL,
             outputs.dL = NULL,
             outputs.dR = NULL,
             nc_inputs = NULL,
             nc_outputs = NULL,
             nd_inputs = NULL,
             nd_outputs = NULL,
             ud_inputs = NULL,
             ud_outputs = NULL)
}
\arguments{
\item{datadea}{Data frame, the data.}

\item{dmus}{Where are (column) the DMUs in \code{datadea}.}

\item{inputs.mL}{Where are (columns) the \code{mL} of fuzzy inputs in \code{datadea}. If an input is not fuzzy or triangular, we put the value or \code{m} respectively.}

\item{inputs.mR}{Where are (columns) the \code{mR} of fuzzy inputs in \code{datadea}. If an input is not fuzzy or triangular, we put \code{NA}.}

\item{inputs.dL}{Where are (columns) the \code{dL} of fuzzy inputs in \code{datadea}. If an input is symmetric, we put \code{d}. If an input is not fuzzy or rectangular, we put \code{NA}.}

\item{inputs.dR}{Where are (columns) the \code{dR} of fuzzy inputs in \code{datadea}. If an input is not fuzzy or symmetric, we put \code{NA}.}

\item{outputs.mL}{Where are (columns) the \code{mL} of fuzzy outputs in \code{datadea}. If an output is not fuzzy or triangular, we put the value or \code{m} respectively.}

\item{outputs.mR}{Where are (columns) the \code{mR} of fuzzy outputs in \code{datadea}. If an output is not fuzzy or triangular, we put \code{NA}.}

\item{outputs.dL}{Where are (columns) the \code{dL} of fuzzy outputs in \code{datadea}. If an output is symmetric, we put \code{d}. If an output is not fuzzy or rectangular, we put \code{NA}.}

\item{outputs.dR}{Where are (columns) the \code{dR} of fuzzy outputs in \code{datadea}. If an output is not fuzzy or symmetric, we put \code{NA}.}

\item{nc_inputs}{A numeric vector containing non-controllable inputs.}

\item{nc_outputs}{A numeric vector containing non-controllable outputs.}

\item{nd_inputs}{A numeric vector containing non-discretionary inputs.}

\item{nd_outputs}{A numeric vector containing non-discretionary outputs.}

\item{ud_inputs}{A numeric vector containing undesirable (good) inputs.}

\item{ud_outputs}{A numeric vector containing undesirable (bad) outputs.}
}
\value{
An object of class \code{deadata_fuzzy}.
}
\description{
This function creates, from a data frame, a \code{deadata_fuzzy} structure, which is as list with fields
  \code{input}, \code{output} and \code{dmunames}. At the same time, \code{input} and \code{output} are lists with fields
  \code{mL}, \code{mR}, \code{dL} and \code{dR}.
  \figure{fuzzynumbers.jpg}{options: width="100\%" alt="Figure: fuzzynumbers.jpg"}
}
\examples{

# Example 1. If inputs and/or outputs are symmetric triangular fuzzy numbers
data("Leon2003")
data_example <- read_data_fuzzy(datadea = Leon2003, 
                                dmus = 1,
                                inputs.mL = 2,
                                inputs.dL = 3,
                                outputs.mL = 4,
                                outputs.dL = 5)
# Example 2. If inputs and/or outputs are non-symmetric triangular fuzzy numbers
data("Kao_Liu_2003")
data_example <- read_data_fuzzy(Kao_Liu_2003, 
                                dmus = 1, 
                                inputs.mL = 2, 
                                outputs.mL = 3:7, 
                                outputs.dL = c(NA, NA, 8, NA, 10),
                                outputs.dR = c(NA, NA, 9, NA, 11))
                                
}
