% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{format}
\alias{format}
\alias{readDat}
\alias{formatDat}
\alias{readAfreq}
\alias{formatAfreq}
\title{Read and Reformat Data}
\usage{
readDat(sfile, svar, lvar, avar, ...)

formatDat(dlong, svar, lvar, avar)

readAfreq(afile, lvar, avar, fvar, ...)

formatAfreq(aflong, lvar, avar, fvar)
}
\arguments{
\item{sfile}{the name of the file containing sample data.}

\item{svar}{the name of the variable for sample ID.}

\item{lvar}{the name of the variable for locus/marker.}

\item{avar}{the name of the variable for allele/haplotype.}

\item{...}{additional arguments for \code{read.csv()}.}

\item{dlong}{a data frame containing sample data.}

\item{afile}{the name of the file containing population allele frequencies.}

\item{fvar}{the name of the variable for population allele frequiency.}

\item{aflong}{a data frame containing population allele frequencies.}
}
\value{
For \code{readDat} and \code{formatDat}, a list with elements
corresponding to samples. Each element of the list is itself a list of
binary vectors, one vector for each locus. For \code{readAfreq} and
\code{formatAfreq}, a list with elements corresponding to loci. The
frequencies at each locus are normalized and sum to 1. Samples, loci, and
alleles are ordered by their IDs/names.
}
\description{
\code{readDat} and \code{readAfreq} read data and population allele
frequencies from \code{csv} files and reformat them for further processing.
\code{formatDat} and \code{formatAfreq} reformat corresponding data frames.
Original data are assumed to be in a long format, with one row per allele.
}
\examples{
sfile <- system.file("extdata", "MozParagon.csv", package = "dcifer")
dsmp  <- readDat(sfile, svar = "sampleID", lvar = "locus", avar = "allele")

# OR, if the dataset is provided as an R data frame, e.g.
dlong <- read.csv(sfile)
# reformat only:
dsmp <- formatDat(dlong, svar = "sampleID", lvar = "locus", avar = "allele")

afile  <- system.file("extdata", "MozAfreq.csv", package = "dcifer")
afreq2 <- readAfreq(afile, lvar = "locus", avar = "allele", fvar = "freq")

# OR, if allele frequencies are provided as an R data frame, e.g.
aflong <- read.csv(afile)
# reformat only:
afreq2 <- formatAfreq(aflong, lvar = "locus", avar = "allele", fvar = "freq")

dsmp2  <- matchAfreq(dsmp, afreq2)

}
\seealso{
\code{\link{matchAfreq}} for making sure that the list containing
sample data is conformable to provided population allele frequencies.
}
