% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-ids-match.R
\name{check_ids_match}
\alias{check_ids_match}
\alias{check_indiv_ids_match}
\alias{check_specimen_ids_match}
\title{Check ids}
\usage{
check_ids_match(
  x,
  y,
  idcol = c("individualID", "specimenID"),
  xname = NULL,
  yname = NULL,
  bidirectional = TRUE
)

check_indiv_ids_match(x, y, xname = NULL, yname = NULL, bidirectional = TRUE)

check_specimen_ids_match(
  x,
  y,
  xname = NULL,
  yname = NULL,
  bidirectional = TRUE
)
}
\arguments{
\item{x, y}{Data frames to compare}

\item{idcol}{Name of column containing ids to compare}

\item{xname, yname}{Names of x and y (to be used in resulting messages)}

\item{bidirectional}{Should mismatches from both x and y be reported?
Defaults to \code{TRUE}; if \code{FALSE}, will return only IDs in \code{y} that are not
present in \code{x} (IDs in \code{x} but not \code{y} will be ignored).}
}
\value{
A condition object indicating whether IDs match (\code{"check_pass"}) or
not (\code{"check_fail"}). Mismatched IDs are included as data within the
object.
}
\description{
Compare IDs (such as individual IDs or specimen IDs) between two data frames.

Ensure that all individual IDs in two data frames match.

Ensure that all specimen IDS in two data frames match
}
\examples{
a <- data.frame(individualID = LETTERS[1:3])
b <- data.frame(individualID = LETTERS[1:4])
check_ids_match(a, b, idcol = "individualID", xname = "a", yname = "b")
a <- data.frame(individualID = LETTERS[1:3])
b <- data.frame(individualID = LETTERS[1:4])
check_specimen_ids_match(a, b, "individual", "biospecimen")
a <- data.frame(specimenID = LETTERS[1:3])
b <- data.frame(specimenID = LETTERS[1:4])
check_specimen_ids_match(a, b, "biospecimen", "assay")
}
