% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{a_dccmidas_mat_est}
\alias{a_dccmidas_mat_est}
\title{Obtains the matrix H_t, R_t and long-run correlations, under the A-DCC-MIDAS model}
\usage{
a_dccmidas_mat_est(est_param, res, Dt, lag_fun = "Beta", N_c, K_c)
}
\arguments{
\item{est_param}{Vector of estimated values}

\item{res}{Array of standardized daily returns, coming from the first step estimation}

\item{Dt}{Matrix of conditional standard deviations (coming from the first step)}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively}

\item{N_c}{Number of (lagged) realizations to use for the standarized residuals forming the long-run correlation}

\item{K_c}{Number of (lagged) realizations to use for the long-run correlation}
}
\value{
A list with the \eqn{H_t}, \eqn{R_t} and long-run correlaton matrices, for each \eqn{t}.
}
\description{
Obtains the matrix H_t, R_t and long-run correlations, under the A-DCC-MIDAS model
For details, see \insertCite{colacito2011component;textual}{dccmidas} and \insertCite{dcc_engle_2002;textual}{dccmidas}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
