% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{db_compute_count}
\alias{db_compute_count}
\title{Aggregates over a discrete field}
\usage{
db_compute_count(data, x, ..., y = n())
}
\arguments{
\item{data}{A table (tbl)}

\item{x}{A discrete variable}

\item{...}{A set of named or unamed aggregations}

\item{y}{The aggregation formula. Defaults to count (n)}
}
\description{
Uses very generic dplyr code to aggregate data.  Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_sql
}
\examples{

library(dplyr)

# Returns the row count per am
mtcars \%>\%
  db_compute_count(am)

# Returns the average mpg per am
mtcars \%>\%
  db_compute_count(am, mean(mpg))
  
# Returns the average and sum of mpg per am
mtcars \%>\%
  db_compute_count(am, mean(mpg), sum(mpg))

}
