% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_modification.R
\name{filtered_fold_dt}
\alias{filtered_fold_dt}
\title{Fold a dataset avoiding overlapping of different time series}
\usage{
filtered_fold_dt(dt, size, id_var, clear_id_var = TRUE)
}
\arguments{
\item{dt}{data.table to be folded}

\item{size}{the size of the data.table}

\item{id_var}{the variable that labels each individual instance of the time series}

\item{clear_id_var}{boolean that decides whether or not the id_var column is deleted}
}
\value{
the filtered data.table
}
\description{
If the dataset that is going to be folded contains several different time series 
instances of the same process, folding it could introduce false rows with data
from different time series. Given an id variable that labels the different 
instances of a time series inside a dataset and a desired size, this function 
folds the dataset and avoids mixing data from different origins in the same instance.
}
\examples{
dt <- dbnR::motor[201:2500]
dt[, n_sec := rep(seq(46), each = 50)] # I'll create secuences of 50 instances each
f_dt <- dbnR::fold_dt(dt, size = 2)
dim(f_dt)
f_dt <- dbnR::filtered_fold_dt(dt, size = 2, id_var = "n_sec")
dim(f_dt)  # The filtered folded dt has a row less for each independent secuence
}
