% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge.dbi.table}
\title{Merge two dbi.tables}
\usage{
\method{merge}{dbi.table}(
  x,
  y,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  all = FALSE,
  all.x = all,
  all.y = all,
  sort = FALSE,
  suffixes = c(".x", ".y"),
  no.dups = TRUE,
  recursive = FALSE,
  ...
)
}
\arguments{
\item{x, y}{\code{\link{dbi.table}}s sharing the same DBI connection.}

\item{by}{A vector of shared column names in \code{x} and \code{y} to merge on.}

\item{by.x, by.y}{character vectors of column names in \code{x} and \code{y} to merge on.}

\item{all}{a logical value. \code{all = TRUE} is shorthand to save setting both
\code{all.x = TRUE} and \code{all.y = TRUE}.}

\item{all.x}{a logical value. When \code{TRUE}, rows from \code{x} that do not have a
matching row in \code{y} are included. These rows will have \code{NA}s in
the columns that are filled with values from \code{y}. The default is
\code{FALSE} so that only rows with data from both \code{x} and \code{y}
are included in the output.}

\item{all.y}{a logical value. Analogous to \code{all.x} above.}

\item{sort}{a logical value. Currently ignored.}

\item{suffixes}{a length-2 character vector. The suffixes to be used for making
non-\code{by} column names unique. The suffix behavior works in a similar
fashion to the \code{\link[base]{merge.data.frame}} method.}

\item{no.dups}{a logical value. When \code{TRUE}, suffixes are also appended to
non-\code{by.y} column names in \code{y} when they have the same column
name as any \code{by.x}.}

\item{recursive}{a logical value. Only used when \code{y} is missing. When \code{TRUE},
\code{merge} is called recursively on each of the just-merged
\code{dbi.table}s. See examples.}

\item{\dots}{additional arguments are ignored.}
}
\value{
a \code{\link{dbi.table}}.
}
\description{
Merge two \code{\link{dbi.table}}s. The \code{dbi.table} method is similar
  to the \code{\link[data.table]{data.table}} method except that the result
  set is only determined up to row order and is not sorted by default.

  Default merge columns: if \code{x} has a foreign key constraint that
  references \code{y} then the columns comprising this key are used; see
  details. When a foreign key cannot be found, then the common columns
  between the two \code{dbi.tables}s are used.

  Use the \code{by}, \code{by.x}, and \code{by.y} arguments explicitly to
  override this default.
}
\details{
Foreign key constraints. Foreign keys can only be queried when (1) the
  \code{dbi.table}'s schema is loaded, and (2) \code{dbi.table} understands
  the underlying database's information schema.

  \code{merge.dbi.table} uses \code{\link{sql.join}} to join \code{x} and
  \code{y} then formats the result set to match the typical \code{merge}
  output.
}
\examples{
  chinook <- dbi.catalog(chinook.duckdb)

  #The Album table has a foreign key constriant that references Artist
  merge(chinook$main$Album, chinook$main$Artist)

  #When y is omitted, x's foreign key relationship is used to determine y
  merge(chinook$main$Album)

  #Multiple foreign keys are supported
  csql(merge(chinook$main$Track))

  #Track references Album but not Artist, Album references Artist
  #This dbi.table includes Artist.Name as well
  csql(merge(chinook$main$Track, recursive = TRUE))

}
