% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranktransform.R
\name{ranktransform}
\alias{ranktransform}
\alias{ranktransform.numeric}
\alias{ranktransform.data.frame}
\title{(Signed) rank transformation}
\usage{
ranktransform(x, ...)

\method{ranktransform}{numeric}(x, sign = FALSE, method = "average", verbose = TRUE, ...)

\method{ranktransform}{data.frame}(
  x,
  sign = FALSE,
  method = "average",
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  ...
)
}
\arguments{
\item{x}{Object.}

\item{...}{Arguments passed to or from other methods.}

\item{sign}{Logical, if \code{TRUE}, return signed ranks.}

\item{method}{Treatment of ties. Can be one of \code{"average"} (default),
\code{"first"}, \code{"last"}, \code{"random"}, \code{"max"} or \code{"min"}. See \code{\link[=rank]{rank()}} for
details.}

\item{verbose}{Toggle warnings.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}
}
\value{
A rank-transformed object.
}
\description{
Transform numeric values with the integers of their rank (i.e., 1st smallest,
2nd smallest, 3rd smallest, etc.). Setting the \code{sign} argument to \code{TRUE} will
give you signed ranks, where the ranking is done according to absolute size
but where the sign is preserved (i.e., 2, 1, -3, 4).
}
\examples{
ranktransform(c(0, 1, 5, -5, -2))
ranktransform(c(0, 1, 5, -5, -2), sign = TRUE)

head(ranktransform(trees))
}
\seealso{
Other transform utilities: 
\code{\link{data_rescale}()},
\code{\link{data_reverse}()},
\code{\link{normalize}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
