% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_values.R, R/ds_heap.R,
%   R/ds_map_bimap.R, R/ds_map_unordered.R
\docType{methods}
\name{values}
\alias{values}
\alias{values,heap-method}
\alias{values,bimap-method}
\alias{values,unordered_map-method}
\title{Get values from an object}
\usage{
values(obj)

\S4method{values}{heap}(obj)

\S4method{values}{bimap}(obj)

\S4method{values}{unordered_map}(obj)
}
\arguments{
\item{obj}{object to extract values from}
}
\value{
returns the extracted values as a \code{list} or, when primitive, as
 a \code{vector}. In case of a \code{heap} also returns \code{key} and \code{handle}
 of the heap node.
}
\description{
Extracts the values from a data structure such as a \code{map}
 or \code{heap} object.
}
\examples{

 # shows the values of a hashmap
 h_map <- hashmap("integer")
 h_map <- insert(h_map, seq(2), list(data.frame(a=1), 3))
 values(h_map)

 # shows the values of a multimap
 m_map <- multimap("integer")
 m_map[seq(2)] <- list(diag(2), rnorm(3))
 values(m_map)

 # shows the values of a heap
 f_heap <- fibonacci_heap("integer")
 f_heap <- insert(f_heap, 1:2, list(diag(2), rnorm(3)))
 values(f_heap)

}
