% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publisher.R
\name{publisher}
\alias{publisher}
\alias{publisher<-}
\title{Get or Set the Publisher of a Dataset Object}
\usage{
publisher(x)

publisher(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{\link[=dataset_df]{dataset_df()}} or
\code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{overwrite}{Logical. Should existing publisher metadata be overwritten?
Defaults to \code{FALSE}. If \code{FALSE} and the field exists, a warning is issued.}

\item{value}{A character string specifying the publisher.}
}
\value{
A character string of length one containing the \code{"publisher"} attribute.
When assigning, the updated object \code{x} is returned invisibly.
}
\description{
The publisher is the entity responsible for holding, archiving, releasing,
or distributing the resource. It is typically included in dataset citation
metadata.

For software, this might refer to a code repository (e.g., GitHub). If both
a hosting platform and a producing institution are involved, use the
publisher for the institution and \code{\link[=creator]{creator()}} with
\code{contributorType = "hostingInstitution"} for the platform.
}
\details{
Adds or retrieves the optional \code{"publisher"} attribute for a dataset object.
This property aligns with \code{dct:publisher} (Dublin Core) and \code{publisher}
(DataCite).
}
\examples{
publisher(orange_df) <- "Wiley"
publisher(orange_df)

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
