% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\name{subsetting}
\alias{subsetting}
\alias{[.dataset}
\alias{$.dataset}
\alias{[[.dataset}
\title{Subsetting datasets}
\usage{
\method{[}{dataset}(x, i, j, drop = FALSE, ...)

\method{$}{dataset}(x, name)

\method{[[}{dataset}(x, i, j, ..., exact = TRUE)
}
\arguments{
\item{x}{A dataset object created with \link{dataset}.}

\item{i, j}{Row and column indices. If \code{j} is omitted, \code{i} is used as column index.}

\item{drop}{logical. If \code{TRUE} the result is coerced to the lowest possible
dimension. The default is to drop if only one column is left, but not to
drop if only one row is left.}

\item{...}{Ignored.}

\item{name}{A \link{name} or a string.}

\item{exact}{Ignored, with a warning.}
}
\description{
Accessing columns, rows, or cells via \code{$}, \code{[[}, or \code{[} is mostly similar to
\link[base:Extract]{regular data frames}. However, the
\itemize{
\item \code{[} always returns a similar dataset by default, even if
only one column is accessed. The title is modified to
from \code{'Original Title'} to \code{'Original Title [subset]'}
\item \code{[[} always returns a vector.
\item \code{$} always returns a vector.
}
}
\examples{
# Subsetting single columns:
iris_dataset[, "Species"]

# Subsetting single column to vector:
iris_dataset$Species
iris_dataset[, "Species"]

# Subsetting a single cell in tabular data:
iris_dataset[[1,2]]

#Subsetting a variable into a vector.
iris_dataset$Species
}
\seealso{
\link{head.dataset}
}
