% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_download.R
\name{dataset_download}
\alias{dataset_download}
\alias{dataset_download_csv}
\title{Download data into a dataset}
\usage{
dataset_download(url, title, author, destfile, type = "csv", ...)

dataset_download_csv(url, title, author, destfile = NULL, ...)
}
\arguments{
\item{url}{a \code{\link{character}} string (or longer vector
    for the \code{"libcurl"} method) naming the URL of a resource to be
    downloaded.}

\item{title}{The title of the dataset.}

\item{author}{A single person or a vector of persons as authors, declared with
\code{\link[utils:person]{person}}.}

\item{destfile}{a character string (or vector, see the \code{url}
    argument) with the file path where the downloaded file is to be
    saved.  Tilde-expansion is performed.}

\item{type}{A file type.  Currently only \code{csv} is implemented that
\code{\link[utils:download.file]{utils::download.file}}.}

\item{...}{Various parameters to pass on to the downloading functions.}
}
\value{
A \code{\link{dataset}} with the downloaded dataset.
}
\description{
A wrapper around \code{\link{dataset}} and
an import function.
}
\examples{
\donttest{
dest_file <- file.path(tempdir(), "iris.csv")
dataset_download(
   url = "https://zenodo.org/record/7421899/files/iris.csv?download=1",
   title = "Iris Dataset",
   author = person(given="Edgar", family="Anderson"),
   publisher = "American Iris Society",
   identifier = "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x",
   destfile = dest_file)
}
}
\keyword{internal}
