% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftChart.R
\name{GetLiftChart}
\alias{GetLiftChart}
\title{Retrieve lift chart data for a model for a data partition (see DataPartition)}
\usage{
GetLiftChart(model, source = DataPartition$VALIDATION)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by the function
GetModelObject, or each element of the list returned by the function GetAllModels.}

\item{source}{Data partition for which lift chart data would be returned. Default is
DataPartition$VALIDATION (see DataPartition)}
}
\value{
data.frame with the following components:
\itemize{
  \item binWeight. Numeric: weight of the bin.  For weighted projects, the sum of the weights of
    all rows in the bin; otherwise, the number of rows in the bin.
  \item actual. Numeric: sum of actual target values in bin.
  \item predicted. Numeric: sum of predicted target values in bin.
}
}
\description{
Retrieve lift chart data for a model for a data partition (see DataPartition)
}
\examples{
\dontrun{
  modelId <- "5996f820af07fc605e81ead4"
  GetLiftChart(modelId)
}
}
