% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{RequestPredictionExplanations}
\alias{RequestPredictionExplanations}
\title{Request prediction explanations computation for a specified model and dataset.}
\usage{
RequestPredictionExplanations(model, datasetId, maxExplanations = NULL,
  thresholdLow = NULL, thresholdHigh = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{datasetId}{character. ID of the prediction dataset for which predictionexplanations
are requested.}

\item{maxExplanations}{integer. Optional. The maximum number of prediction explanations to supply
per row of the dataset, default: 3.}

\item{thresholdLow}{numeric. Optional. The lower threshold, below which a prediction must
score in order for prediction explanations to be computed for a row in the dataset. If
neither \code{threshold_high} nor \code{threshold_low} is specified, prediction
explanations will be computed for all rows.}

\item{thresholdHigh}{numeric. Optional. The high threshold, above which a prediction must score
in order for prediction explanations to be computed. If neither \code{threshold_high} nor
\code{threshold_low} is specified, prediction explanations will be computed for all rows.}
}
\value{
job Id
}
\description{
In order to create PredictionExplanations for a particular model and dataset, you must first:
Compute feature impact for the model via \code{RequestFeatureImpact()}
Compute a PredictionExplanationsInitialization for the model via
\code{RequestPredictionExplanationsInitialization()}
Compute predictions for the model and dataset via
\code{RequestPredictionsForDataset()}
After prediction explanations are requested information about them can be accessed using
the functions \code{GetPredictionExplanationsMetadataFromJobId} and
\code{GetPredictionExplanationsMetadata}. Prediction explanations themselves can be accessed
using the functions \code{GetPredictionExplanationsRows},
\code{GetPredictionExplanationsRowsAsDataFrame}, and \code{DownloadPredictionExplanations}.
}
\details{
\code{threshold_high} and \code{threshold_low} are optional filters applied to speed up
computation.  When at least one is specified, only the selected outlier rows will have
prediction explanations computed. Rows are considered to be outliers if their predicted
value (in case of regression projects) or probability of being the positive
class (in case of classification projects) is less than \code{threshold_low} or greater than
\code{thresholdHigh}.  If neither is specified, prediction explanations will be computed for
all rows.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(projectId, modelId)
  RequestPredictionExplanations(model, datasetId)
}
}
