% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_unit2baseunit.R
\name{util_unit2baseunit}
\alias{util_unit2baseunit}
\title{Detect base unit from composite units}
\usage{
util_unit2baseunit(
  unit,
  warn_ambiguities = !exists("warn_ambiguities", .unit2baseunitenv),
  unique = TRUE
)
}
\arguments{
\item{unit}{\link{character} a unit}

\item{warn_ambiguities}{\link{logical} warn about all ambiguous units}

\item{unique}{\link{logical} choose the more \code{SI}-like unit in case of ambiguities}
}
\value{
\link{character} all possible or the preferable (unique set \code{TRUE})
base units. Can be \code{character(0)}, if unit is invalid
or uniqueness was requested, but even using precedence
rules of \code{SI}-closeness do not help selecting the most
suitable unit.
}
\description{
Detect base unit from composite units
}
\examples{
\dontrun{
util_unit2baseunit("\%")
util_unit2baseunit("d\%")

# Invalid unit
util_unit2baseunit("aa\%")
util_unit2baseunit("aa\%", unique = FALSE)

util_unit2baseunit("a\%")

# Invalid unit
util_unit2baseunit("e\%")
util_unit2baseunit("e\%", unique = FALSE)

util_unit2baseunit("E\%")
util_unit2baseunit("Eg")

# Invalid unit
util_unit2baseunit("E")
util_unit2baseunit("E", unique = FALSE)

util_unit2baseunit("EC")
util_unit2baseunit("EK")
util_unit2baseunit("µg")
util_unit2baseunit("mg")
util_unit2baseunit("°C")
util_unit2baseunit("k°C")
util_unit2baseunit("kK")
util_unit2baseunit("nK")

# Ambiguous units, if used with unique = FALSE
util_unit2baseunit("kg")
util_unit2baseunit("cd")
util_unit2baseunit("Pa")
util_unit2baseunit("kat")
util_unit2baseunit("min")

# atto atom units or astronomical units, both in state "accepted"
util_unit2baseunit("au")
util_unit2baseunit("au", unique = FALSE)

# astronomical units or micro are, both in state "accepted"
util_unit2baseunit("ua")
util_unit2baseunit("ua", unique = FALSE)

util_unit2baseunit("kt")

# parts per trillion or pico US_liquid_pint, both in state "common",
# but in this case, plain count units will be preferred
util_unit2baseunit("ppt")
util_unit2baseunit("ppt", unique = FALSE)

util_unit2baseunit("ft")
util_unit2baseunit("yd")
util_unit2baseunit("pt")

# actually the same, but both only common, and to my knowledge not-so-common
# gram-force vs. kilogram-force (kilo pond)
util_unit2baseunit("kgf")
util_unit2baseunit("kgf", unique = FALSE)

util_unit2baseunit("at")
util_unit2baseunit("ph")
util_unit2baseunit("nt")
}
}
\keyword{internal}
