% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_generate_pages_from_report.R
\name{util_generate_pages_from_report}
\alias{util_generate_pages_from_report}
\title{Convert a \link[=dq_report2]{dataquieR report v2} to a named list of web pages}
\usage{
util_generate_pages_from_report(
  report,
  template,
  disable_plotly,
  progress = progress,
  progress_msg = progress_msg,
  block_load_factor,
  dir
)
}
\arguments{
\item{report}{\link[=dq_report2]{dataquieR report v2}.}

\item{template}{\link{character} template to use, only the name, not the path}

\item{disable_plotly}{\link{logical} do not use \code{plotly}, even if installed}

\item{progress}{\code{\link{function}} lambda for progress in percent -- 1-100}

\item{progress_msg}{\code{\link{function}} lambda for progress messages}

\item{block_load_factor}{\link{numeric} multiply size of parallel compute blocks
by this factor.}

\item{dir}{\link{character} output directory for potential \code{iframes}.}
}
\value{
named list, each entry becomes a file with the name of the entry.
the contents are \code{HTML} objects as used by \code{htmltools}.
}
\description{
Convert a \link[=dq_report2]{dataquieR report v2} to a named list of web pages
}
\examples{
\dontrun{
devtools::load_all()
prep_load_workbook_like_file("meta_data_v2")
report <- dq_report2("study_data", dimensions = NULL, label_col = "LABEL");
save(report, file = "report_v2.RData")
report <- dq_report2("study_data", label_col = "LABEL");
save(report, file = "report_v2_short.RData")
}

}
\seealso{
Other html: 
\code{\link{util_extract_all_ids}()}
}
\concept{html}
\concept{process}
\keyword{internal}
