% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_check_group_levels.R
\name{util_check_group_levels}
\alias{util_check_group_levels}
\title{Check data for observer levels}
\usage{
util_check_group_levels(
  study_data,
  group_vars,
  min_obs_in_subgroup = -Inf,
  max_obs_in_subgroup = +Inf,
  min_subgroups = -Inf,
  max_subgroups = +Inf
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{group_vars}{\link{variable} the name of the observer, device or reader
variable}

\item{min_obs_in_subgroup}{\link{integer} from=0. optional argument if
\code{group_vars} are used. This argument
specifies the minimum number of observations
that is required to include a subgroup
(level) of the group variable named by
\code{group_vars} in the analysis. Subgroups
with fewer observations are excluded.}

\item{max_obs_in_subgroup}{\link{integer} from=0. optional argument if
\code{group_vars} are used. This argument
specifies the maximum number of observations
that is required to include a subgroup
(level) of the group variable named by
\code{group_vars} in the analysis. Subgroups
with more observations are excluded.}

\item{min_subgroups}{\link{integer} from=0. optional argument if a "group_var" is
used. This argument specifies the
minimum no. of subgroups (levels)
included "group_var". If the variable
defined in "group_var" has fewer
subgroups it is split for analysis.}

\item{max_subgroups}{\link{integer} from=0. optional argument if a "group_var" is
used. This argument specifies the
maximum no. of subgroups (levels)
included "group_var". If the variable
defined in "group_var" has more
subgroups it is split for analysis.}
}
\value{
modified study data frame
}
\description{
Check data for observer levels
}
\examples{
\dontrun{
study_data <- prep_get_data_frame("study_data")
meta_data <- prep_get_data_frame("meta_data")
prep_prepare_dataframes(.label_col = LABEL)
util_check_group_levels(ds1, "CENTER_0")
dim(util_check_group_levels(ds1, "USR_BP_0", min_obs_in_subgroup = 400))
}


}
\seealso{
\link{prep_min_obs_level}

Other data_management: 
\code{\link{util_assign_levlabs}()},
\code{\link{util_check_data_type}()},
\code{\link{util_compare_meta_with_study}()},
\code{\link{util_dichotomize}()},
\code{\link{util_merge_data_frame_list}()},
\code{\link{util_rbind}()},
\code{\link{util_remove_na_records}()},
\code{\link{util_replace_hard_limit_violations}()},
\code{\link{util_study_var2factor}()},
\code{\link{util_table_of_vct}()}
}
\concept{data_management}
\concept{robustness}
\keyword{internal}
