test_that("prep_datatype_from_data works", {
  skip_if_not_installed("withr")
  withr::local_options(dataquieR.CONDITIONS_WITH_STACKTRACE = TRUE,
                   dataquieR.ERRORS_WITH_CALLER = TRUE,
                   dataquieR.WARNINGS_WITH_CALLER = TRUE,
                   dataquieR.MESSAGES_WITH_CALLER = TRUE)
  expect_message(
    prep_valuelabels_from_data(c("Species", "xzy", "Sepal.Width"), iris),
    all = TRUE,
    regexp =
      paste("The following.+resp_vars.+are missing from the",
            ".+study_data.+Won.t return a type for them:.+xzy.+")
  )
  expect_error(
    prep_valuelabels_from_data(1234, iris),
    regexp =
      paste(".+resp_vars.+should be missing or give variable",
             "names referring the study_data."))
  expect_identical(
    dataquieR::prep_valuelabels_from_data(tibble::as_tibble(iris)),
    dataquieR::prep_valuelabels_from_data(iris))
  expect_error(dataquieR::prep_valuelabels_from_data(),
               regexp =
              "Need study data as a data frame in the argument .+study_data.+")
  vl <- dataquieR::prep_valuelabels_from_data(iris)
  expect_equal(vl,
                    list(
                      VALUE_LABELS = c(
                        Sepal.Length = NA,
                        Sepal.Width = NA,
                        Petal.Length = NA,
                        Petal.Width = NA,
                        Species = "1 = setosa | 2 = versicolor | 3 = virginica"
                      ),
                      ModifiedStudyData = structure(
                        list(
                          Sepal.Length = c(
                            5.1,
                            4.9,
                            4.7,
                            4.6,
                            5,
                            5.4,
                            4.6,
                            5,
                            4.4,
                            4.9,
                            5.4,
                            4.8,
                            4.8,
                            4.3,
                            5.8,
                            5.7,
                            5.4,
                            5.1,
                            5.7,
                            5.1,
                            5.4,
                            5.1,
                            4.6,
                            5.1,
                            4.8,
                            5,
                            5,
                            5.2,
                            5.2,
                            4.7,
                            4.8,
                            5.4,
                            5.2,
                            5.5,
                            4.9,
                            5,
                            5.5,
                            4.9,
                            4.4,
                            5.1,
                            5,
                            4.5,
                            4.4,
                            5,
                            5.1,
                            4.8,
                            5.1,
                            4.6,
                            5.3,
                            5,
                            7,
                            6.4,
                            6.9,
                            5.5,
                            6.5,
                            5.7,
                            6.3,
                            4.9,
                            6.6,
                            5.2,
                            5,
                            5.9,
                            6,
                            6.1,
                            5.6,
                            6.7,
                            5.6,
                            5.8,
                            6.2,
                            5.6,
                            5.9,
                            6.1,
                            6.3,
                            6.1,
                            6.4,
                            6.6,
                            6.8,
                            6.7,
                            6,
                            5.7,
                            5.5,
                            5.5,
                            5.8,
                            6,
                            5.4,
                            6,
                            6.7,
                            6.3,
                            5.6,
                            5.5,
                            5.5,
                            6.1,
                            5.8,
                            5,
                            5.6,
                            5.7,
                            5.7,
                            6.2,
                            5.1,
                            5.7,
                            6.3,
                            5.8,
                            7.1,
                            6.3,
                            6.5,
                            7.6,
                            4.9,
                            7.3,
                            6.7,
                            7.2,
                            6.5,
                            6.4,
                            6.8,
                            5.7,
                            5.8,
                            6.4,
                            6.5,
                            7.7,
                            7.7,
                            6,
                            6.9,
                            5.6,
                            7.7,
                            6.3,
                            6.7,
                            7.2,
                            6.2,
                            6.1,
                            6.4,
                            7.2,
                            7.4,
                            7.9,
                            6.4,
                            6.3,
                            6.1,
                            7.7,
                            6.3,
                            6.4,
                            6,
                            6.9,
                            6.7,
                            6.9,
                            5.8,
                            6.8,
                            6.7,
                            6.7,
                            6.3,
                            6.5,
                            6.2,
                            5.9
                          ),
                          Sepal.Width = c(
                            3.5,
                            3,
                            3.2,
                            3.1,
                            3.6,
                            3.9,
                            3.4,
                            3.4,
                            2.9,
                            3.1,
                            3.7,
                            3.4,
                            3,
                            3,
                            4,
                            4.4,
                            3.9,
                            3.5,
                            3.8,
                            3.8,
                            3.4,
                            3.7,
                            3.6,
                            3.3,
                            3.4,
                            3,
                            3.4,
                            3.5,
                            3.4,
                            3.2,
                            3.1,
                            3.4,
                            4.1,
                            4.2,
                            3.1,
                            3.2,
                            3.5,
                            3.6,
                            3,
                            3.4,
                            3.5,
                            2.3,
                            3.2,
                            3.5,
                            3.8,
                            3,
                            3.8,
                            3.2,
                            3.7,
                            3.3,
                            3.2,
                            3.2,
                            3.1,
                            2.3,
                            2.8,
                            2.8,
                            3.3,
                            2.4,
                            2.9,
                            2.7,
                            2,
                            3,
                            2.2,
                            2.9,
                            2.9,
                            3.1,
                            3,
                            2.7,
                            2.2,
                            2.5,
                            3.2,
                            2.8,
                            2.5,
                            2.8,
                            2.9,
                            3,
                            2.8,
                            3,
                            2.9,
                            2.6,
                            2.4,
                            2.4,
                            2.7,
                            2.7,
                            3,
                            3.4,
                            3.1,
                            2.3,
                            3,
                            2.5,
                            2.6,
                            3,
                            2.6,
                            2.3,
                            2.7,
                            3,
                            2.9,
                            2.9,
                            2.5,
                            2.8,
                            3.3,
                            2.7,
                            3,
                            2.9,
                            3,
                            3,
                            2.5,
                            2.9,
                            2.5,
                            3.6,
                            3.2,
                            2.7,
                            3,
                            2.5,
                            2.8,
                            3.2,
                            3,
                            3.8,
                            2.6,
                            2.2,
                            3.2,
                            2.8,
                            2.8,
                            2.7,
                            3.3,
                            3.2,
                            2.8,
                            3,
                            2.8,
                            3,
                            2.8,
                            3.8,
                            2.8,
                            2.8,
                            2.6,
                            3,
                            3.4,
                            3.1,
                            3,
                            3.1,
                            3.1,
                            3.1,
                            2.7,
                            3.2,
                            3.3,
                            3,
                            2.5,
                            3,
                            3.4,
                            3
                          ),
                          Petal.Length = c(
                            1.4,
                            1.4,
                            1.3,
                            1.5,
                            1.4,
                            1.7,
                            1.4,
                            1.5,
                            1.4,
                            1.5,
                            1.5,
                            1.6,
                            1.4,
                            1.1,
                            1.2,
                            1.5,
                            1.3,
                            1.4,
                            1.7,
                            1.5,
                            1.7,
                            1.5,
                            1,
                            1.7,
                            1.9,
                            1.6,
                            1.6,
                            1.5,
                            1.4,
                            1.6,
                            1.6,
                            1.5,
                            1.5,
                            1.4,
                            1.5,
                            1.2,
                            1.3,
                            1.4,
                            1.3,
                            1.5,
                            1.3,
                            1.3,
                            1.3,
                            1.6,
                            1.9,
                            1.4,
                            1.6,
                            1.4,
                            1.5,
                            1.4,
                            4.7,
                            4.5,
                            4.9,
                            4,
                            4.6,
                            4.5,
                            4.7,
                            3.3,
                            4.6,
                            3.9,
                            3.5,
                            4.2,
                            4,
                            4.7,
                            3.6,
                            4.4,
                            4.5,
                            4.1,
                            4.5,
                            3.9,
                            4.8,
                            4,
                            4.9,
                            4.7,
                            4.3,
                            4.4,
                            4.8,
                            5,
                            4.5,
                            3.5,
                            3.8,
                            3.7,
                            3.9,
                            5.1,
                            4.5,
                            4.5,
                            4.7,
                            4.4,
                            4.1,
                            4,
                            4.4,
                            4.6,
                            4,
                            3.3,
                            4.2,
                            4.2,
                            4.2,
                            4.3,
                            3,
                            4.1,
                            6,
                            5.1,
                            5.9,
                            5.6,
                            5.8,
                            6.6,
                            4.5,
                            6.3,
                            5.8,
                            6.1,
                            5.1,
                            5.3,
                            5.5,
                            5,
                            5.1,
                            5.3,
                            5.5,
                            6.7,
                            6.9,
                            5,
                            5.7,
                            4.9,
                            6.7,
                            4.9,
                            5.7,
                            6,
                            4.8,
                            4.9,
                            5.6,
                            5.8,
                            6.1,
                            6.4,
                            5.6,
                            5.1,
                            5.6,
                            6.1,
                            5.6,
                            5.5,
                            4.8,
                            5.4,
                            5.6,
                            5.1,
                            5.1,
                            5.9,
                            5.7,
                            5.2,
                            5,
                            5.2,
                            5.4,
                            5.1
                          ),
                          Petal.Width = c(
                            0.2,
                            0.2,
                            0.2,
                            0.2,
                            0.2,
                            0.4,
                            0.3,
                            0.2,
                            0.2,
                            0.1,
                            0.2,
                            0.2,
                            0.1,
                            0.1,
                            0.2,
                            0.4,
                            0.4,
                            0.3,
                            0.3,
                            0.3,
                            0.2,
                            0.4,
                            0.2,
                            0.5,
                            0.2,
                            0.2,
                            0.4,
                            0.2,
                            0.2,
                            0.2,
                            0.2,
                            0.4,
                            0.1,
                            0.2,
                            0.2,
                            0.2,
                            0.2,
                            0.1,
                            0.2,
                            0.2,
                            0.3,
                            0.3,
                            0.2,
                            0.6,
                            0.4,
                            0.3,
                            0.2,
                            0.2,
                            0.2,
                            0.2,
                            1.4,
                            1.5,
                            1.5,
                            1.3,
                            1.5,
                            1.3,
                            1.6,
                            1,
                            1.3,
                            1.4,
                            1,
                            1.5,
                            1,
                            1.4,
                            1.3,
                            1.4,
                            1.5,
                            1,
                            1.5,
                            1.1,
                            1.8,
                            1.3,
                            1.5,
                            1.2,
                            1.3,
                            1.4,
                            1.4,
                            1.7,
                            1.5,
                            1,
                            1.1,
                            1,
                            1.2,
                            1.6,
                            1.5,
                            1.6,
                            1.5,
                            1.3,
                            1.3,
                            1.3,
                            1.2,
                            1.4,
                            1.2,
                            1,
                            1.3,
                            1.2,
                            1.3,
                            1.3,
                            1.1,
                            1.3,
                            2.5,
                            1.9,
                            2.1,
                            1.8,
                            2.2,
                            2.1,
                            1.7,
                            1.8,
                            1.8,
                            2.5,
                            2,
                            1.9,
                            2.1,
                            2,
                            2.4,
                            2.3,
                            1.8,
                            2.2,
                            2.3,
                            1.5,
                            2.3,
                            2,
                            2,
                            1.8,
                            2.1,
                            1.8,
                            1.8,
                            1.8,
                            2.1,
                            1.6,
                            1.9,
                            2,
                            2.2,
                            1.5,
                            1.4,
                            2.3,
                            2.4,
                            1.8,
                            1.8,
                            2.1,
                            2.4,
                            2.3,
                            1.9,
                            2.3,
                            2.5,
                            2.3,
                            1.9,
                            2,
                            2.3,
                            1.8
                          ),
                          Species = c(
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            1L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            2L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L,
                            3L
                          )
                        ),
                        row.names = c(NA,-150L),
                        class = "data.frame"
                      )
                    ))
})
