% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_combine_missing_lists.R
\name{util_combine_missing_lists}
\alias{util_combine_missing_lists}
\title{Combine missing-lists for a set of variables to be displayed in the same
heat-map}
\usage{
util_combine_missing_lists(
  resp_vars,
  study_data,
  meta_data,
  label_col,
  include_sysmiss,
  cause_label_df,
  assume_consistent_codes = TRUE,
  expand_codes = assume_consistent_codes,
  suppressWarnings = FALSE
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{include_sysmiss}{\link{logical} Optional, if TRUE system missingness (NAs)
is evaluated in the summary plot}

\item{cause_label_df}{\link{data.frame} missing code table. If missing codes have
labels the respective data frame can be
specified here, see \link{cause_label_df}}

\item{assume_consistent_codes}{\link{logical} if TRUE and no labels are given and
the same missing/jump code is used
for more than one variable, the
labels assigned for this code will
be the same for all variables.}

\item{expand_codes}{\link{logical} if TRUE, code labels are copied from other
variables, if the code is the same and the
label is set somewhere}

\item{suppressWarnings}{\link{logical} warn about consistency issues with missing
and jump lists}
}
\value{
a \link{list} with:
\itemize{
\item \code{ModifiedStudyData}: data frame with re-coded (if needed) study data
\item \code{cause_label_df}: data frame with re-coded missing codes suitable for all
variables
}
}
\description{
Combine missing-lists for a set of variables to be displayed in the same
heat-map
}
