% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_shape_or_scale.R
\name{acc_shape_or_scale}
\alias{acc_shape_or_scale}
\title{Function to compare observed versus expected distributions}
\usage{
acc_shape_or_scale(
  resp_vars,
  dist_col,
  guess,
  par1,
  par2,
  end_digits,
  label_col,
  study_data,
  meta_data
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the continuous measurement variable}

\item{dist_col}{\link{variable attribute} the name of the variable attribute in
meta_data that provides the expected
distribution of a study variable}

\item{guess}{\link{logical} estimate parameters}

\item{par1}{\link{numeric} first parameter of the distribution if applicable}

\item{par2}{\link{numeric} second parameter of the distribution if applicable}

\item{end_digits}{\link{logical} check for end digits preferences}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}
}
\value{
a list with:
\itemize{
\item \code{SummaryData}: \link{data.frame} underlying the plot
\item \code{SummaryPlot}: \link{ggplot2} probability distribution plot
\item \code{SummaryTable}: \link{data.frame} with the columns \code{Variables} and \code{GRADING}
}
}
\description{
This implementation contrasts the empirical distribution of a measurement
variables against assumed distributions. The approach is adapted from the
idea of rootograms (Tukey 1977) which is also applicable for count data
(Kleiber and Zeileis 2016).
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item This implementation is restricted to data of type float or integer.
\item Missing codes are removed from resp_vars (if defined in the metadata)
\item The user must specify the column of the metadata containing probability
distribution (currently only: normal, uniform, gamma)
\item Parameters of each distribution can be estimated from the data or are
specified by the user
\item A histogram-like plot contrasts the empirical vs. the technical
distribution
}
}

\seealso{
\href{https://dfg-qa.ship-med.uni-greifswald.de/VIN_acc_impl_shape_or_scale.html}{Online Documentation}
}
