% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{recordDerivation}
\alias{recordDerivation}
\alias{recordDerivation,DataPackage-method}
\title{Record derivation relationships between objects in a DataPackage}
\usage{
recordDerivation(x, ...)

\S4method{recordDerivation}{DataPackage}(x, sourceID, derivedIDs, ...)
}
\arguments{
\item{x}{a DataPackage object}

\item{...}{Additional parameters}

\item{sourceID}{the identifier of the source object in the relationship}

\item{derivedIDs}{an identifier or list of identifiers of objects that were derived from the source}
}
\description{
Record a derivation relationship that expresses that a target object has been derived from a source object.
For use with DataONE, a best practice is to specify the subject and predicate as DataONE persistent identifiers 
(https://mule1.dataone.org/ArchitectureDocs-current/design/PIDs.html). If the objects are not known to DataONE, then local identifiers can be
used, and these local identifiers may be promoted to DataONE PIDs when the package is uploaded to a DataONE member node.
}
\details{
A derived relationship is created for each value in the list "objectIDs".  For each derivedId, one statement will be
added expressing that it was derived from the sourceId.  The predicate is will be an RDF property (as a IRI) from the W3C PROV
specification, namely, "http://www.w3.org/ns/prov#wasDerivedFrom"
}
\examples{
\dontrun{
dp <- new("DataPackage")
recordDerivation(dp, "doi:1234/_030MXTI009R00_20030812.40.1", 
                 "doi:1234/_030MXTI009R00_20030812.45.1")
                     }
}
\seealso{
\code{\link{DataPackage-class}}
}
