% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{methods}
\name{d1SolrQuery}
\alias{d1SolrQuery}
\alias{d1SolrQuery,D1Client,character-method}
\alias{d1SolrQuery,D1Client,list-method}
\title{A method to query the DataONE solr endpoint of the Coordinating Node.}
\usage{
d1SolrQuery(x, solrQuery)

\S4method{d1SolrQuery}{D1Client,list}(x, solrQuery)

\S4method{d1SolrQuery}{D1Client,character}(x, solrQuery)
}
\arguments{
\item{x}{the D1Client (environment) being queried}

\item{solrQuery}{list or character: a fully encoded query string}
}
\value{
the solr response (XML)
}
\description{
It expects any lucene reserved characters to already be escaped with backslash. If
solrQuery is a list, it is expected to have field names as attributes and search
values as the values in the list.
}
\examples{
\dontrun{ 
library(dataone)
d1c <- D1Client("PROD", "urn:node:KNB")
queryParams <- list(q="id:doi*", rows="5", 
    fq="(abstract:chlorophyll AND dateUploaded:[2000-01-01T00:00:00Z TO NOW])", 
    fl="title,id,abstract,size,dateUploaded,attributeName")
result <- d1SolrQuery(d1c, queryParams)
}
}
\seealso{
\code{\link[=D1Client-class]{D1Client}}{ class description.}
}

