% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-gdpcap.r
\docType{data}
\name{gdpcap}
\alias{gdpcap}
\title{Datos GDP-per capita}
\format{
Este set de datos contiene las siguientes columnas:
\describe{
\item{pais}{Nombre del país.}
\item{pais.cod}{Codificación del país.}
\item{gdp.pc}{GDP per capita, en US dollars.}
\item{y}{GDP per capita, en miles de US dollars.}
}
}
\source{
Los datos fueron obtenidos desde la web
\url{https://data.worldbank.org/indicator/NY.GDP.PCAP.CD}
}
\usage{
data(gdpcap)
}
\description{
Datos del producto interno bruto per capita, por pais.
}
\examples{
data(gdpcap)    
head(gdpcap) 
unique(gdpcap$pais)
hist(gdpcap$y, breaks=20,xlab='PIB per capita (miles de US$)', col='orange', las=1)
}
\keyword{datasets}
