% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describeDatas.R
\docType{data}
\name{idahohd}
\alias{idahohd}
\title{Tree height-diameter data from Idaho (USA)}
\format{
Contains five variables, as follows:
\describe{
  \item{plot}{Plot number.}
  \item{tree}{Tree within plot.}
\item{species}{A factor with levels DF = Douglas-fir, GF = Grand fir, 
SF = Subalpine fir, WL = Western larch,
                WC = Western red cedar, WP = White pine.}
\item{dbh}{Diameter 137 cm perpendicular to the bole, cm.}
\item{height}{Height of the tree, in m.}
 }
}
\source{
The data were assembled from the 'ufc' dataframe from the \eqn{alr4} library.
}
\usage{
data(idahohd)
}
\description{
These data are forest inventory measures from the Upper Flat Creek stand 
of the University of Idaho Experimental Forest, dated 1991.
}
\examples{
data(idahohd)    
head(idahohd) 
plot(height~dbh, data=idahohd)
}
\references{
Weisberg S. 2014. Applied Linear Regression. 4th edition. New York: Wiley.
}
\keyword{datasets}
