% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{pinaster}
\alias{pinaster}
\title{Tree volume for Pinus pinaster in the Baixo-Mino, Galicia, Spain.}
\format{
Contains tree-level variables, as follows:
\describe{
  \item{stand}{stand number from the sample tree was selected.}
\item{si}{Site index of the stand.}
\item{tree.no}{tree number.}
\item{dbh}{Diameter at breast height, in cm.}
\item{toth}{Total height, in m.}
 \item{d4}{Upper-stem diameter at 4 m, in cm.}
\item{volwb}{Tree gross volume, in m\eqn{^{3}}{^3} with bark.}
\item{volwob}{Tree gross volume, in m\eqn{^{3}}{^3} without bark.}
 }
}
\source{
The data are provided courtesy of Dr Christian Salas-Eljatib at
the Universidad de Chile (Santiago, Chile).
}
\usage{
data(pinaster)
}
\description{
These are volume measurements data of sample trees in the Baixo-Mino region in Galicia, Spain.
}
\examples{
data(pinaster)    
head(pinaster) 
}
\references{
- Salas C, Nieto L, Irisarri A. 2005. Modelos de volumen para Pinus pinaster Ait. en la comarca del Baixo Mino,
  Galicia, España. Quebracho 12: 11-22. \url{https://eljatib.com/publication/2005-12-01_modelos_de_volumen_p/}
}
\keyword{datasets}
