% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valesta.R
\name{valesta}
\alias{valesta}
\title{A function that computes validation statistics.}
\usage{
valesta(y.obs = y.obs, y.pred = y.pred)
}
\arguments{
\item{y.obs}{Observed values of the variable of interest.}

\item{y.pred}{Predicted values of the variable of interest.}
}
\value{
This function returns the following statistics as a vector: 
(RMSD,RMSD.p,AD,AD.p,AAD,AAD.p); where RMSD.p stands for
RMSD expressed as a percentage, and the same applied to AD.p and AAD.p.
}
\description{
This function computes validation statistics, as the RMSD, AD and AAD of any
   response vector 'y.pred' using as real values the vector 'y.obs'. 
   The computed statistics are:  root mean square differences (RMSD);
   aggregated difference (AD); and  
   aggregated of the absolute value differences (AAD). Be sure that both predicted
    and observed values are expressed in the same measurement unit. 
    Thus, be careful if the model uses a transformation of the response variable.
}
\note{
Check the reference for further details.
}
\examples{

#creating a fake dataframe
set.seed(1234)
df <- as.data.frame(cbind(Y=rnorm(30, 30,9), X=rnorm(30, 450,133)))
df
#fitting a candidate model
mod1 <- lm(Y~X, data=df)
#using the function
valesta(y.obs=df$Y,y.pred=fitted(mod1))
}
\references{
Salas C, Ene L, Gregoire TG, Nasset E, Gobakken T. 2010. Modelling tree diameter
 from airborne laser scanning derived variables: a comparison of spatial statistical
 models. Remote Sensing of Environment 114(6):1277-1285. \doi{10.1016/j.rse.2010.01.020}
}
\author{
Christian Salas-Eljatib.
}
