% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{grGrandfir}
\alias{grGrandfir}
\title{Height and diameter growth of Grand fir (Abies grandis) trees.}
\format{
The data frame contains the following columns:
\describe{
\item{forest}{national forest}	
\item{forest.id}{national forest code}	
\item{habtype}{habitat type}
\item{hab.id}{habitat type code}
\item{tree.id}{Tree code}											
\item{decade}{Decade, as an integer.}	
\item{age}{Total age, in yrs.}
\item{dbh}{Diameter at breast height, in cm.}
\item{htot}{Total height, in m.}
 }
}
\source{
Data were collected by Dr Albert Stage (R.I.P.), from the US Forest Service
in Moscow, Idaho, USA. Data were compiled by Prof. Andrew Robinson, for his Statistical lectures at the
University of Idaho (USA), meanwhile Dr Christian Salas-Eljatib was a student there.
}
\usage{
data(grGrandfir)
}
\description{
Height and diameter growth data of Grand fir (Abies grandis) trees in Idaho, USA. 
The data contain measurements of 66 dominant trees from national forests in Idaho, USA.
 These data are fully documented in Stage (1963).
}
\examples{
data(grGrandfir)    
head(grGrandfir)
library(lattice)
xyplot(dbh ~ age | tree.id, type="b", data=grGrandfir) 
}
\references{
- Stage, A. R., 1963. A mathematical approach to polymorphic site index curves
  for Grand fir. Forest Science 9 (2), 167-180. \doi{10.1093/forestscience/9.2.167}
}
\keyword{datasets}
