% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{boreal}
\alias{boreal}
\title{Spatial coordinates of trees in a boreal forest (Finland).}
\format{
The data frame contains six variables as follows:
\describe{
\item{id}{tree id}											
\item{x}{Cartesian position at the X-axis, in m.}
\item{y}{Cartesian position at the Y-axis, in m.}
\item{dbh}{Diameter at breast-height, in cm.}
\item{height}{Total height, in m.} 
\item{species}{Species name.}
 }
}
\source{
Data were obtained from the files available at \doi{10.6084/m9.figshare.19698352.v1}.
}
\usage{
data(boreal)
}
\description{
Tree location of trees from a 8.8ha sample plot established in subarctic old-growth forest
 located in the Varriostrict nature reserve, northeastern Fennoscandia
  (67 44 N, 29 34 E), in Finland.  The plot was rectangular (180 m × 500 m), but for 
  practical reasons, missing a smaller rectangle (20 m × 100 m) in its south-east corner.
}
\examples{
data(boreal)    
head(boreal) 
tapply(boreal$dbh,boreal$species,mean)
library(lattice)
histogram(~dbh|species, data=boreal)
}
\references{
Pouta P, Kulha N, Kuuluvainen T, Aakala T. 2022. Partitioning of Space Among Trees in
 an Old-Growth Spruce Forest in Subarctic Fennoscandia. Frontiers in Forests and Global Change 5: 817248. \doi{10.3389/ffgc.2022.817248}
}
\keyword{datasets}
