% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{orange}
\alias{orange}
\title{Diameter growth of orange trees}
\format{
A time series data containing the following columns:
\describe{
\item{tree.id}{an ordered factor indicating the tree on which the measurement is made. The ordering is according to increasing maximum diameter.}
\item{time}{a numeric vector giving the numbers of days since 1968/12/31}
\item{girth}{a numeric vector of trunk perimeter (mm). This is probably a circumference at breast height, a standard measurement in forestry.}
\item{dbh}{a numeric vector of diameter at breast height (mm).}
\item{site}{a factor variable, representing site conditions with two levels.}
\item{spp}{a factor variable, representing tree species with three levels.}
 }
}
\source{
Modified by Christian Salas-Eljatib from the Orange R dataframe.
}
\usage{
data(orange)
}
\description{
The orange data frame has 35 rows and four columns of records of the growth of orange trees.
}
\examples{
data(orange)

coplot(dbh ~ time | tree.id, data = orange, show.given = FALSE)
m1 <- nls(dbh ~ SSlogis(time, Asym, xmid, scal),
           data = orange, subset = tree.id == 3)
plot(dbh ~ time, data = orange, subset = tree.id == 3,
     xlab = "Time (number of days since 1968/12/31)",
     ylab = "Tree diameter (mm)", las = 1)
time <- seq(0, 1600, length.out = 101)
lines(time, predict(m1, list(time = time)))
}
\keyword{datasets}
