% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_data}
\alias{show_data}
\title{Display a table in a window}
\usage{
show_data(
  data,
  title = NULL,
  options = NULL,
  show_classes = TRUE,
  type = c("popup", "modal"),
  width = "65\%"
)
}
\arguments{
\item{data}{a data object (either a \code{matrix} or a \code{data.frame}).}

\item{title}{Title to be displayed in window.}

\item{options}{Arguments passed to \code{\link[reactable:reactable]{reactable::reactable()}}.}

\item{show_classes}{Show variables classes under variables names in table header.}

\item{type}{Display table in a pop-up or in modal window.}

\item{width}{Width of the window, only used if \code{type = "popup"}.}
}
\value{
No value.
}
\description{
Display a table in a window
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  theme = bslib::bs_theme(version = 5L),
  actionButton(
    inputId = "show1",
    label = "Show data in popup",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show2",
    label = "Show data in modal",
    icon = icon("eye")
  ),
  actionButton(
    inputId = "show3",
    label = "Show data without classes",
    icon = icon("eye")
  )
)

server <- function(input, output, session) {
  observeEvent(input$show1, {
    show_data(MASS::Cars93, title = "MASS::Cars93 dataset")
  })
  observeEvent(input$show2, {
    show_data(MASS::Cars93, title = "MASS::Cars93 dataset", type = "modal")
  })
  observeEvent(input$show3, {
    show_data(
      data = MASS::Cars93,
      title = "MASS::Cars93 dataset",
      show_classes = FALSE,
      options = list(pagination = 10),
      type = "modal"
    )
  })
}

if (interactive())
  shinyApp(ui, server)
}
