% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{config_geo}
\alias{config_geo}
\title{Configure map}
\usage{
config_geo(p, popup.on.hover = TRUE, highlight.on.hover = TRUE,
  hide.antarctica = TRUE, hide.hawaii.and.alaska = FALSE,
  border.width = 1, border.opacity = 1, border.color = "#FDFDFD",
  highlight.fill.color = "#FC8D59", highlight.border.opacity = 1,
  highlight.border.color = "rgba(250, 15, 160, 0.2)",
  highlight.fill.opacity = 0.85, highlight.border.width = 2,
  data.url = NULL, ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{popup.on.hover}{whether to show popover.}

\item{highlight.on.hover}{whether to enable popover.}

\item{hide.antarctica}{whether to hide Antarctica.}

\item{hide.hawaii.and.alaska}{whether to hide hide Hawaii and Alaska.}

\item{border.width}{country border width.}

\item{border.opacity}{Opacity of country borders.}

\item{border.color}{color of country borders.}

\item{highlight.fill.color}{bubbles fill color on hover.}

\item{highlight.border.opacity}{bubbles opacity on hover.}

\item{highlight.border.color}{bubble's border opacity on hover.}

\item{highlight.fill.opacity}{bubble's opacity on hover.}

\item{highlight.border.width}{bubble's width on hover.}

\item{data.url}{topo.json data url.}

\item{...}{any other parameter.}
}
\description{
Define options of the map.
}
\examples{
data <- data.frame(name = c("USA", "FRA", "CHN", "RUS", "COG", "DZA"),
    values = c("N. America", "EU", "Asia", "EU", "Africa", "Africa"),
    letters = LETTERS[1:6])

data \%>\%
    datamaps(default = "lightgray") \%>\%
    add_choropleth(name, values) \%>\%
    config_geo(hide.antarctica = FALSE,
               border.width = 2,
               border.opacity = 0.6,
               border.color = "gray",
               highlight.border.color = "green",
               highlight.fill.color = "lightgreen")

}
