% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{filter_by}
\alias{filter_by}
\title{Filter data.frame using params passed}
\usage{
filter_by(data, title = NULL, description = NULL, keywords = NULL,
  quiet = FALSE)
}
\arguments{
\item{data}{A data.frame that will be filtered}

\item{title}{A string to match with the title column in the data.frame}

\item{description}{A string to match with the description column in the data.frame}

\item{keywords}{A string to match with the keywords column in the data.frame}

\item{quiet}{A logical param that set if the function will print info message
in console}
}
\value{
A data.frame that matches
}
\description{
Filter data.frame using params passed
}
\examples{
library(dataesgobr)
\donttest{
datasets <- search_by_title('salud')
datasetsFiltered <- filter_by(datasets, 'salud', 'vacuna')
datasetsFiltered2 <- filter_by(datasets, 'salud', keywords = 'enfermedad')
}
}
