% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{check_file}
\alias{check_file}
\title{Check if the dataset has a correct format}
\usage{
check_file(file, noconfirm = FALSE, outfile = NULL)
}
\arguments{
\item{file}{A string The file to check}

\item{noconfirm}{A logical, Use TRUE to skip confirmation about file writing}

\item{outfile}{A character the path where the file will be save if it need to
be modify, NULL to use the file's directory}
}
\value{
Return a logical, if the file is correct it will be TRUE, else FALSE
}
\description{
Check if the dataset has a correct format
}
\examples{
library(dataesgobr)
file <- system.file("extdata", "fichero.csv", package="dataesgobr")
correct <- check_file(file, noconfirm = TRUE, outfile = tempdir())
}
