% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{handle_restyle_traces}
\alias{handle_restyle_traces}
\title{Wrapper for adjusting axis lims and hiding traces}
\usage{
handle_restyle_traces(
  source_id,
  session,
  dframe,
  scaling = 0.05,
  xvar,
  yvar,
  trace_map,
  max_id_group_trace,
  input_sel_rows,
  flush = TRUE
)
}
\arguments{
\item{source_id}{character, plotly source id}

\item{session}{session object}

\item{dframe}{data frame/tibble (grouped/ungrouped)}

\item{scaling}{numeric, 1 +/- scaling applied to x lims for xvar and yvar}

\item{xvar}{character, name of xvar, must be in dframe}

\item{yvar}{character, name of yvar, must be in dframe}

\item{trace_map}{matrix, with columns for trace name (col 1) and trace id (col 2)}

\item{max_id_group_trace}{numeric, max id of plotly trace from original data (not outlier traces)}

\item{input_sel_rows}{numeric, input from DT grouptable}

\item{flush}{character, \code{plotlyProxy} settings}
}
\value{
Used for it's side effect - no return
}
\description{
Wrapper for adjusting axis lims and hiding traces
}
