% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-rows.R
\name{check_rows}
\alias{check_rows}
\title{Check Rows}
\usage{
check_rows(data, min_row = 1, max_row = max_nrow(),
  data_name = substitute(data))
}
\arguments{
\item{data}{The data frame to check.}

\item{min_row}{A count of the minimum number of rows.}

\item{max_row}{A count of the maximum number of rows.}

\item{data_name}{A string of the name of data.}
}
\value{
Throws an informative error or returns an invisible copy of
data.
}
\description{
Checks the number of rows in data.
}
\details{
By default (\code{min_row = 1}) data must include at least one row.
}
\examples{
try(check_rows(data.frame()))
try(check_rows(data.frame(x = 1), 2))
}
