% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_stats.R
\name{interval_stats}
\alias{interval_stats}
\alias{int_mean}
\alias{int_var}
\alias{int_cov}
\alias{int_cor}
\title{Statistics for Interval Data}
\usage{
int_mean(x, var_name, method = "CM", ...)

int_var(x, var_name, method = "CM", ...)

int_cov(x, var_name1, var_name2, method = "CM", ...)

int_cor(x, var_name1, var_name2, method = "CM", ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the vraiable name or the column location (multiple vraiables are allowed).}

\item{method}{methods to calculate statistics: CM (default), VM, QM, SE, FV, EJD, GQ, SPT.}

\item{...}{additional parameters}

\item{var_name1}{the vraiable name or the column location (multiple vraiables are allowed).}

\item{var_name2}{the vraiable name or the column location (multiple vraiables are allowed).}
}
\value{
A numeric value: the mean, variance, covariance, or correlation.
}
\description{
Functions to compute the mean, variance, covariance, and correlation of interval-valued data.
}
\details{
...
}
\examples{
data(mushroom.int)
int_mean(mushroom.int, var_name = "Pileus.Cap.Width")
int_mean(mushroom.int, var_name = 2:3)

var_name <- c("Stipe.Length", "Stipe.Thickness")
method <- c("CM", "FV", "EJD")
int_mean(mushroom.int, var_name, method)
int_var(mushroom.int, var_name, method)

var_name1 <- "Pileus.Cap.Width"
var_name2 <- c("Stipe.Length", "Stipe.Thickness")
method <- c("CM", "VM", "EJD", "GQ", "SPT")
int_cov(mushroom.int, var_name1, var_name2, method)
int_cor(mushroom.int, var_name1, var_name2, method)
}
\seealso{
int_mean int_var int_cov int_cor
}
\author{
Han-Ming Wu
}
