% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_set.R
\name{set_as_numeric_matrix}
\alias{set_as_numeric_matrix}
\title{Numeric matrix preparation for Machine Learning.}
\usage{
set_as_numeric_matrix(
  data_set,
  intercept = FALSE,
  all_cols = FALSE,
  sparse = FALSE
)
}
\arguments{
\item{data_set}{data.table}

\item{intercept}{Should a constant column be added? (logical, default to FALSE)}

\item{all_cols}{For each factor, should we create all possible
dummies, or should we drop a reference dummy? (logical, default to FALSE)}

\item{sparse}{Should the resulting matrix be of a (sparse) Matrix
class? (logical, default to FALSE)}
}
\description{
Prepare a numeric matrix from a data.table. This matrix is suitable for
machine learning purposes, since factors are binarized. It may be sparsed,
include an intercept, and drop a reference column for each factor if
required (when using \code{lm()}, for instance)
}
