% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Aggregate}
\alias{Aggregate}
\title{Aggregate child values of a \code{Node}, recursively.}
\usage{
Aggregate(node, attribute, aggFun, ...)
}
\arguments{
\item{node}{the \code{Node} on which to aggregate}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} or a \bold{property/active} of each \code{Node} in the tree, e.g. \code{acme$Get("p")} or \code{acme$Get("position")}
  \item b.) the name of a \bold{method} of each \code{Node} in the tree, e.g. \code{acme$Get("levelZeroBased")}, where e.g. \code{acme$levelZeroBased <- function() acme$level - 1}
  \item c.) a \bold{function}, whose first argument must be a \code{Node} e.g. \code{acme$Get(function(node) node$cost * node$p)}
 }}

\item{aggFun}{the aggregation function to be applied to the children's \code{attributes}}

\item{...}{any arguments to be passed on to attribute (in case it's a function)}
}
\description{
The \code{Aggregate} method lets you fetch an attribute from a \code{Node}'s children, and then aggregate them
using \code{aggFun}. For example, you can aggregate cost by summing costs of child \code{Nodes}. This is especially useful in the
context of tree traversal, when using post-order traversal mode.
}
\details{
As with \code{\link{Get}}, the attribute can be a field, a method or a function. If the attribute on a child
is \code{NULL}, \code{Aggregate} is called recursively on its children.
}
\examples{
data(acme)

#Aggregate on a field
Aggregate(acme, "cost", sum)

#This is the same as:
HomeRolledAggregate <- function(node) {
  sum(sapply(node$children, function(child) {
    if (!is.null(child$cost)) child$cost
    else HomeRolledAggregate(child)
  }))
}
HomeRolledAggregate(acme)

#Aggregate using Get
print(acme, "cost", minCost = acme$Get(Aggregate, "cost", min))

#use Aggregate with a function:
Aggregate(acme, function(x) x$cost * x$p, sum)

#cache values along the way
acme$Do(function(x) x$cost <- Aggregate(x, "cost", sum), traversal = "post-order")
acme$IT$cost

}
\seealso{
\code{\link{Node}}
}
