% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_methods_traversal.R
\name{Get}
\alias{Get}
\title{Traverse a Tree and Collect Values}
\usage{
Get(nodes, attribute, ..., format = NULL, inheritFromAncestors = FALSE,
  simplify = c(TRUE, FALSE, "array", "regular"))
}
\arguments{
\item{nodes}{The nodes on which to perform the Get (e.g. obtained via \code{\link{Traverse}}}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} of each \code{Node} in the tree
  \item b.) the name of a \bold{method} of each \code{Node} in the tree
  \item c.) a \bold{function}, whose first argument must be a \code{Node}
 }}

\item{...}{in case the \code{attribute} is a function or a method, the ellipsis is passed to it as additional arguments.}

\item{format}{can be a function that transforms the collected values, e.g. for printing}

\item{inheritFromAncestors}{if \code{TRUE}, then the path above a \code{Node} is searched to get the \code{attribute} in case it is NULL.}

\item{simplify}{same as \code{\link{sapply}}, i.e. TRUE, FALSE or "array". Additionally, you can sepcify "regular" if
each returned value is of length > 1, and equally named. See below for an example.}
}
\value{
a vector containing the \code{atrributes} collected during traversal, in traversal order. \code{NULL} is converted
to NA, such that \code{length(Node$Get) == Node$totalCount}
}
\description{
The \code{Get} method is one of the most important ones of the \code{data.tree} package. It lets you traverse a tree
and collect values along the way. Alternatively, you can call a method or a function on each \code{\link{Node}}.
}
\examples{
data(acme)
acme$Get("level")
acme$Get("totalCount")

calculateAggregateChildCost <- function(node, fun) {
 if (node$isLeaf) return(node$cost)
 fun(sapply(node$children, function(x) x$averageCost))
}

myFormat <- function(x) {
 format(x, nsmall=2, scientific = FALSE)
}

acme$Get(calculateAggregateChildCost,
        mean,
        traversal = "post-order",
        format = myFormat)

#simplify = "regular" will preserve names
acme$Get(function(x) c(position = x$position, level = x$level), simplify = "regular")
}
\seealso{
\code{\link{Node}}

\code{\link{Set}}
}

