% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dcbarchart}
\alias{dcbarchart}
\title{dcbarchart adds a bar chart to the dashboard}
\usage{
dcbarchart(x, title = paste(x, "bar chart"), spansize = 4,
  width = dashboard.env$outerwidth * spansize/12, height = 250,
  gap = width/2)
}
\arguments{
\item{x}{column name of data frame \code{data} for drawing a bar chart}

\item{title}{character for the title of the generated bar chart}

\item{spansize}{integer between 1 to 12 for the width of the element in the row}

\item{width}{integer for the width (in pixel) of the element in the web page}

\item{height}{integer for the height (in pixel) of the element in the web page}

\item{gap}{integer for adjusting the width of each bar}
}
\description{
\code{dcbarchart} generates a bar chart
}
\examples{
dashboard_open(data=iris) # other options: pathoutput=getwd() ...
dcpiechart(x=names(iris)[5])
dcbarchart(x=names(iris)[1] , gap=75)
dcpiechart(x=names(iris)[2])
dctable(index=names(iris)[5])
dashboard_launch(browse = FALSE) # Just generates files. Server is not launched
}

