% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.plot.r
\name{gl.pcoa.plot}
\alias{gl.pcoa.plot}
\title{Bivariate plot of the results of a PCoA ordination}
\usage{
gl.pcoa.plot(glPca, data, scale = FALSE, ellipse = FALSE, p = 0.95,
  labels = "pop", hadjust = 1.5, vadjust = 1, xaxis = 1, yaxis = 2)
}
\arguments{
\item{glPca}{Name of the glPca object containing the factor scores and eigenvalues [required]}

\item{data}{Name of the genlight object containing the SNP genotypes by specimen and population [required]}

\item{scale}{Flag indicating whether or not to scale the x and y axes in proportion to \% variation explained [default FALSE]}

\item{ellipse}{Flag to indicate whether or not to display ellipses to encapsulate points for each population [default FALSE]}

\item{p}{Value of the percentile for the ellipse to encapsulate points for each population [default 0.95]}

\item{labels}{-- Flag to specify the labels are to be added to the plot. ["none"|"ind"|"pop"|"interactive"|"legend", default = "pop"]}

\item{hadjust}{Horizontal adjustment of label position [default 1.5]}

\item{vadjust}{Vertical adjustment of label position [default 1]}

\item{xaxis}{Identify the x axis from those available in the ordination (xaxis <= nfactors)}

\item{yaxis}{Identify the y axis from those available in the ordination (yaxis <= nfactors)}
}
\value{
A plot of the ordination
}
\description{
This script takes output from the ordination generated by gl.pcoa() and plots the individuals classified by population.
}
\details{
The factor scores are taken from the output of gl.pcoa() -- an object of class glPca -- and the population assignments are taken from
from the original data file. The specimens are shown in a bivariate plot optionally with adjacent labels
and enclosing ellipses. Population labels on the plot are shuffled so as not to overlap (using package \{directlabels\}).
This can be a bit clunky, as the labels may be some distance from the points to which they refer, but it provides the
opportunity for moving labels around using graphics software (Adobe Illustrator).

Any pair of axes can be specified from the ordination, provided they are within the range of the nfactors value provided to gl.pcoa(). Axes can be scaled to
represent the proportion of variation explained. In any case, the proportion of variation explained by each axis is provided in the axis label.

Points displayed in the ordination can be identified if the option labels="interactive" is chosen, in which case the resultant plot is
ggplotly() friendly. Running ggplotyly() with no parameters will replot the data and allow identification of points by moving the mouse
over them. Refer to the plotly package for further information. Do not forget to load the library via library(plotly).
}
\examples{
gl <- testset.gl
levels(pop(gl))<-c(rep("Coast",5),rep("Cooper",3),rep("Coast",5),
rep("MDB",8),rep("Coast",7),"Em.subglobosa","Em.victoriae")
pcoa<-gl.pcoa(gl,nfactors=5)
gl.pcoa.plot(pcoa, gl, ellipse=TRUE, p=0.99, labels="pop",hadjust=1.5, vadjust=1)
gl.pcoa.plot(pcoa, gl, ellipse=TRUE, p=0.99, labels="pop",hadjust=1.5, vadjust=1, xaxis=1, yaxis=3)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
