% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.monomorphs.r
\name{gl.filter.monomorphs}
\alias{gl.filter.monomorphs}
\title{Remove monomorphic loci, including those with all NAs}
\usage{
gl.filter.monomorphs(gl, probar = FALSE)
}
\arguments{
\item{gl}{-- name of the input genlight object [required]}

\item{probar}{-- switch to output progress bar [default is false]}
}
\value{
A genlight object with monomorphic loci removed
}
\description{
This script deletes monomorphic loci from a genlight \{adegenet\} object
}
\details{
A DArT dataset will not have monomorphic loci, but they can arise when populations are deleted by assignment or by using
the delete option in gl.pop.recode(). Retaining monomorphic loci unnecessarily increases the size of the dataset.
}
\examples{
gl <- gl.filter.monomorphs(testset.gl)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
