% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.plot.network.r
\name{gl.plot.network}
\alias{gl.plot.network}
\title{Represents a distance or dissimilarity matrix as a network}
\usage{
gl.plot.network(
  D,
  x = NULL,
  method = "fr",
  node.size = 3,
  node.label = FALSE,
  node.label.size = 0.7,
  node.label.color = "black",
  alpha = 0.005,
  title = "Network based on genetic distance",
  verbose = NULL
)
}
\arguments{
\item{D}{A distance or dissimilarity matrix generated by dist() or gl.dist()
[required].}

\item{x}{A genlight object from which the D matrix was generated
[default NULL].}

\item{method}{One of "fr", "kk" or "drl" [default "fr"].}

\item{node.size}{Size of the symbols for the network nodes [default 3].}

\item{node.label}{TRUE to display node labels [default FALSE].}

\item{node.label.size}{Size of the node labels [default 0.7].}

\item{node.label.color}{Color of the text of the node labels
[default 'black'].}

\item{alpha}{Upper threshold to determine which links between nodes to display
[default 0.005].}

\item{title}{Title for the plot
[default "Network based on genetic distance"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
This script takes a distance matrix generated by dist() and represents the
relationship among the specimens as a network diagram. In order to use this
script, a decision is required on a threshold for relatedness to be
represented as link in the network, and on the layout used to create the
diagram.
}
\details{
The threshold for relatedness to be represented as a link in the network is
specified as a quantile. Those relatedness measures above the quantile are
plotted as links, those below the quantile are not. Often you are looking for
relatedness outliers in comparison with the overall relatedness among
individuals, so a very conservative quantile is used (e.g. 0.004), but
ultimately, this decision is made as a matter of trial and error. One way to
approach this trial and error is to try to achieve a sparse set of links
between unrelated 'background' individuals so that the stronger links are
preferentially shown.

There are several layouts from which to choose. The most popular are given as
options in this script.
\itemize{
\item fr -- Fruchterman, T.M.J. and Reingold, E.M. (1991). Graph Drawing by
Force-directed Placement. Software -- Practice and Experience 21:1129-1164.
\item kk -- Kamada, T. and Kawai, S.: An Algorithm for Drawing General
Undirected Graphs. Information Processing Letters 31:7-15, 1989.
\item drl -- Martin, S., Brown, W.M., Klavans, R., Boyack, K.W., DrL:
Distributed Recursive (Graph) Layout. SAND Reports 2936:1-10, 2008.
}

Colors of node symbols are those of the rainbow.
}
\examples{
if ((requireNamespace("rrBLUP", quietly = TRUE)) & (requireNamespace("gplots", quietly = TRUE))) {
  test <- gl.subsample.loc(platypus.gl, n = 100)
  test <- gl.keep.ind(test, ind.list = indNames(test)[1:10])
  D <- gl.grm(test, legendx = 0.04)
  gl.plot.network(D, test)
}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
