% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDArch.R
\name{runDArch}
\alias{runDArch}
\title{Forward-propagates data through the network}
\usage{
runDArch(darch, data, inputLayer = 1, outputLayer = length(darch@layers),
  matMult = getParameter(".matMult"))
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{data}{The input data to execute the darch on.}

\item{inputLayer}{Into which layer the given data is to be fed. Absolute
number starting at 1 for the input layer.}

\item{outputLayer}{The output of which layer is to be returned, absolute
number starting a 0 for the input layer (i.e. pre-processed data is
returned).}

\item{matMult}{Function to use for matrix multiplication.}
}
\value{
The network output
}
\description{
Runs the \code{DArch} in a feed-forward manner and returns the output.
}
\details{
Input and output layer can be chosen via the parameters \code{inputLayer}
and \code{outputLayer}.
}
\seealso{
\code{\link{darch}}

Other darch execute functions: \code{\link{runDArchDropout}}
}
\keyword{internal}

