% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_multiregistration.R
\name{detect_multiregistration}
\alias{detect_multiregistration}
\title{Detect multi-registration}
\usage{
detect_multiregistration(activitylog, level_of_aggregation, timestamp,
  threshold_in_seconds, details, filter_condition)
}
\arguments{
\item{activitylog}{The activity log (renamed/formatted using functions rename_activity_log and convert_timestamp_format)}

\item{level_of_aggregation}{Level of aggregation at which multi-registration should be detected (either "resource" or "case")}

\item{timestamp}{Type of timestamp that needs to be taken into account in the analysis (either "start", "complete" or "both")}

\item{threshold_in_seconds}{Threshold which is applied to determine whether multi-registration occurs (expressed in seconds) (time gaps smaller than threshold are considered as multi-registration)}

\item{details}{Boolean indicating wheter details of the results need to be shown}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
activitylog containing the rows of the original activity log for which multi-registration is present
}
\description{
Function detecting multi-registration for the same case or by the same resource at the same point in time
}
\examples{
\donttest{
data("hospital_actlog")
detect_multiregistration(activitylog = hospital_actlog, threshold_in_seconds = 10)
}
}
