% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{predict.dann}
\alias{predict.dann}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
\method{predict}{dann}(object, new_data, type = "class", ...)
}
\arguments{
\item{object}{of class inheriting from "dann"}

\item{new_data}{A data frame.}

\item{type}{Type of prediction. (class, prob)}

\item{...}{unused}
}
\value{
A data frame containing either class or class probabilities. Adheres to tidy models standards.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest Neighbor Classification publication.}.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")

test <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(test) <- c("X1", "X2", "Y")

model <- dann(Y ~ X1 + X2, train)
predict(model, test, "class")

predict(model, test, "prob")
}
