% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_norm_zscore.R
\name{zscore}
\alias{zscore}
\title{Z-score normalization}
\usage{
zscore(nmean = 0, nsd = 1)
}
\arguments{
\item{nmean}{new mean for normalized data}

\item{nsd}{new standard deviation for normalized data}
}
\value{
returns the z-score transformation object
}
\description{
Scale data using z-score normalization.

\eqn{zscore = (x - mean(x))/sd(x)}
}
\examples{
data(iris)
head(iris)

trans <- zscore()
trans <- fit(trans, iris)
tiris <- transform(trans, iris)
head(tiris)

itiris <- inverse_transform(trans, tiris)
head(itiris)
}
