% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_lstm.R
\name{ts_lstm}
\alias{ts_lstm}
\title{LSTM}
\usage{
ts_lstm(preprocess = NA, input_size = NA, epochs = 10000L)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{epochs}{maximum number of epochs}
}
\value{
a \code{ts_lstm} object.
}
\description{
Creates a time series prediction object that uses the LSTM.
It wraps the pytorch library.
}
\examples{
\donttest{
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_lstm(ts_norm_gminmax(), input_size=4, epochs = 10000L)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
}
